'SCRIPT:  	Log uploads.vbs
'AUTHOR:  	Gene6
'DATE:    	2004/10/15
'DESC:    	Log every upload to a log file
'NOTE:		Every entry has the form "date time#username#filename#filenamereal#from#to#time#speed


'Constants
Delimiter = "#"
ForAppending = 8

sub OnFileUploaded()

	'Create the file path
	strYear = Year(Date)

	strMonth = Month(Date)
	' add the leading zero
	if (strMonth < 10) Then
		strMonth = "0" & strMonth
	end if

	strDay = Day(Date)
	' add the leading zero
	if (strDay < 10) Then
		strDay = "0" & strDay
	end if

	LogFilename = Server.LogPath & Domain.Name & "-" & strYear & "-" & strMonth & "-" & strDay & "-uploads.log"
	
	Set fso = CreateObject("Scripting.fileSystemObject")
	Set LogObj = fso.OpenTextFile(LogFilename, ForAppending, true)

	Line = FormatDateTime(Now) & Delimiter & Client.Username & Delimiter & Client.Filename & Delimiter & Client.FilenameReal & Delimiter & Client.RestartPos & Delimiter & Client.FilePosition & Delimiter & Client.TransferTime & Delimiter & Client.TransferSpeed

	LogObj.WriteLine(Line)
	LogObj.Close
end sub